IF EXISTS( SELECT * FROM SYS.OBJECTS 
			WHERE NAME ='TRG_RC_CLI_AUDIT' AND TYPE = 'TR')
BEGIN
	DROP TRIGGER dbo.TRG_RC_CLI_AUDIT 
END
GO
GO 
CREATE TRIGGER [dbo].[TRG_RC_CLI_AUDIT] ON [dbo].[RC_CLI] 
FOR UPDATE
AS 

BEGIN TRY
if update(RZ_CLI) or update(NM_FANT) or update(DATA_NASC) or update(CD_REGI) or update(DATAULTANIVERSARIO) or update(DT_NASC) or update(OBS)
begin

INSERT INTO RC_CLI_AUDIT
	(CD_EMP
	,CD_FILIAL
	,CD_CLI
	,RZ_CLI
	,NM_FANT
	,DATA_NASC
	,DATAULTANIVERSARIO
	,DT_NASC
	,CD_REGI
	,DT_CAD_AUDIT
	,CD_USU
	,DT_CAD
	,OBS
	,CD_CID
	,END_CLI
	,BAIRRO )
SELECT 
	 d.CD_EMP
	,d.CD_FILIAL
	,d.CD_CLI
	,d.RZ_CLI
	,d.NM_FANT
	,d.DATA_NASC
	,d.DATAULTANIVERSARIO
	,d.DT_NASC
	,d.CD_REGI
	,GETDATE()
	,i.CD_USU_ALT
	,D.DT_CAD
	,D.OBS
	,D.CD_CID
	,D.END_CLI
	,D.BAIRRO
  FROM 
	DELETED d INNER JOIN INSERTED i ON
	(d.CD_EMP <> i.CD_EMP OR
	d.CD_FILIAL <> i.CD_FILIAL OR
	d.CD_CLI <> i.CD_CLI OR
	d.RZ_CLI <> i.RZ_CLI OR
	d.NM_FANT <> i.NM_FANT OR
	d.DATA_NASC <> i.DATA_NASC OR 
	d.DATAULTANIVERSARIO <> i.DATAULTANIVERSARIO OR 
	d.DT_NASC <> i.DT_NASC OR 
	d.CD_REGI <> i.CD_REGI OR
	d.CD_USU <> i.CD_USU or	
	d.OBS <> I.OBS)	 
end	
END TRY
BEGIN CATCH 
	   declare @erro varchar (500) = ERROR_MESSAGE();
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;
	   raiserror (@erro,16, 1)	
			
END CATCH
